/*
 * HideMouse - Hides the mouse by moving it off screen when inactive
 * Copyright 2005 Thomas Stewart
 * 
 * Distribuded under the terms of the GNU General Public License
 * 
 * Version 0.1
 */
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Text;
using System.Runtime.InteropServices;
using System.Timers;
namespace HideMouse
{
	/// <summary>
	/// Summary description for HideMouse.
	/// </summary>
	public class HideMouse : System.Windows.Forms.Form
	{
		private System.Windows.Forms.NotifyIcon notifyIcon1;
		private System.Windows.Forms.ContextMenu contextMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.ComponentModel.IContainer components;

		private System.Timers.Timer m_Timer;
		private int m_nInterval;
		int oldx=0, oldy=0, newx, newy;

		public HideMouse()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			m_Timer = new System.Timers.Timer ();
			m_Timer.Elapsed += new System.Timers.ElapsedEventHandler(m_Timer_Elapsed);
			Interval = 30 * 1000; // 30 seconds
			EnableTimer();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(HideMouse));
			this.notifyIcon1 = new System.Windows.Forms.NotifyIcon(this.components);
			this.contextMenu1 = new System.Windows.Forms.ContextMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			// 
			// notifyIcon1
			// 
			this.notifyIcon1.ContextMenu = this.contextMenu1;
			this.notifyIcon1.Icon = ((System.Drawing.Icon)(resources.GetObject("notifyIcon1.Icon")));
			this.notifyIcon1.Text = "HideMouse";
			this.notifyIcon1.Visible = true;
			this.notifyIcon1.DoubleClick += new System.EventHandler(this.menuItem2_Click);
			// 
			// contextMenu1
			// 
			this.contextMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						 this.menuItem1,
																						 this.menuItem2});
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.Text = "Quit";
			this.menuItem1.Click += new System.EventHandler(this.menuItem1_Click);
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 1;
			this.menuItem2.Text = "About";
			this.menuItem2.Click += new System.EventHandler(this.menuItem2_Click);
			// 
			// HideMouse
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(292, 266);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.Name = "HideMouse";
			this.ShowInTaskbar = false;
			this.Text = "HideMouse";
			this.WindowState = System.Windows.Forms.FormWindowState.Minimized;

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new HideMouse());
		}

		public int Interval
		{
			get 
			{
				return m_nInterval;
			}
			set 
			{
				m_nInterval = value;
				m_Timer.Interval = m_nInterval;
			}
		}

		protected void EnableTimer()
		{
			m_Timer.Enabled = true;
		}

		protected void DisableTimer()
		{
			m_Timer.Enabled = false;
		}

		protected bool IsTimerEnabled()
		{
			return m_Timer.Enabled;
		}

		private void m_Timer_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
		{
			Win32Class.POINT Point = new Win32Class.POINT();

			Win32Class.GetCursorPos(ref Point);
			newx=Point.X;
			newy=Point.Y;

			//MessageBox.Show("newx:" + newx + " newy:" + newy + " oldx:" + oldx + " oldy:" + oldy);
			if(newx == oldx && newy == oldy) 
			{
				//MessageBox.Show("sleeping");
				Win32Class.SetCursorPos(6400, 4800);
			}
			oldx=newx;
			oldy=newy;
		}

		private void menuItem1_Click(object sender, EventArgs e)
		{
			notifyIcon1.Visible = false;
			Application.Exit();
		}

		private void menuItem2_Click(object sender, EventArgs e)
		{
			MessageBox.Show("Hides the mouse by moving it off screen when inactive.\n\n" +
				"Copyright (c) 2005 Thomas Stewart\n" +
				"Distribuded under the terms of the GNU General Public License",
				"HideMouse");
		}
	}
	public class Win32Class
	{
		public Win32Class()
		{
		}
		[DllImport("user32.dll", EntryPoint = "GetCursorPos")] 
		static public extern bool GetCursorPos(ref POINT lpPoint);

		[DllImport("user32.dll", EntryPoint = "SetCursorPos")] 
		static public extern bool SetCursorPos(int X, int Y);

		public struct POINT
		{
			public int X;
			public int Y;
		}
	}
}