/*
 * Decompiled with CFR 0.152.
 */
package FreeAuth;

import FreeAuth.AES_PBE_BC;
import FreeAuth.HTTP;
import FreeAuth.MD5;
import FreeAuth.RSA;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import org.bouncycastle.security.SecureRandom;

public class FreeAuth
extends MIDlet
implements CommandListener {
    private Command doNextCommand = new Command("Next", 1, 2);
    private Command checkForDefaultsNoCommand = new Command("No", 1, 1);
    private Command checkForDefaultsYesCommand = new Command("Yes", 1, 2);
    private Command newAliasDeleteCommand = new Command("Delete", 1, 1);
    private Command newManSecDeleteCommand = new Command("Delete", 1, 1);
    private Command ManualSecretCommand = new Command("Manual Entry", 1, 2);
    private Command aboutMainCommand = new Command("About", 1, 2);
    private Command aboutMenuCommand = new Command("About", 1, 3);
    private Command exitMainCommand = new Command("Exit", 1, 1);
    private Command exitMenuCommand = new Command("Exit", 1, 3);
    private Command backCommand = new Command("Back", 2, 1);
    private Command cancelCommand = new Command("Cancel", 2, 1);
    private Command tzsaveCommand = new Command("Save", 2, 2);
    private Command timezoneCommand = new Command("Time Zone", 1, 2);
    private Command newPassCodeCommand = new Command("New OTP", 1, 2);
    private Command mainMenuCommand = new Command("Main Menu", 1, 1);
    private Command infoCommand = new Command("Info", 1, 3);
    private Command resetSecretCommand = new Command("Reset Secret", 1, 3);
    private Command deleteSecretCommand = new Command("Delete Secret", 1, 3);
    private Command backupCommand = new Command("DB Backup", 1, 3);
    private Command restoreCommand = new Command("DB Restore", 1, 3);
    private Command wipeCommand = new Command("DB Wipe", 1, 3);
    private Command testDefCommand = new Command("Testing Defaults", 1, 3);
    private Command selectSecretCommand = new Command("Select", 1, 2);
    private Command switchCharSetCommand = new Command("Switch CharSet", 1, 3);
    private Command uploadAlert = new Command("OK", 8, 1);
    private String currentAction = "";
    private String nextAction = "";
    private String seed = "";
    private String secret = "";
    private String initdate = "";
    private String PIN = "";
    private String pindis = "";
    private String alias = "";
    private String newalias = "";
    private String search = "";
    private int manualsecret = 0;
    private RecordStore meta = null;
    private RecordStore rs = null;
    private int totalRecords = 0;
    private int currentRecord = -1;
    private int timez = 12;
    private int firstRun = 0;
    private String usenetwork = "Y";
    private String epoch;
    private Calendar cnow;
    private Date now = new Date();
    private long lastpress = 0L;
    private long thispress = 0L;
    private long serverts = 0L;
    private long serverepoch = 0L;
    private long aliasmode = 0L;
    private char lastkey;
    private int OTPbits = 64;
    private AES_PBE_BC secretdecode;
    private String tmpbuf = "";
    protected Timer timer;
    protected TimerTask updateTask;
    private Canvas lowinput = null;
    private String UserAgent = new String(this.getAppProperty("MIDlet-Name")) + " version " + new String(this.getAppProperty("MIDlet-Version"));
    private String modulus = new String(this.getAppProperty("Modulus"));

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
        System.out.println("Closing RS due to app closing.");
        this.secret = "";
        this.alias = "";
        this.seed = "";
        try {
            this.meta.closeRecordStore();
            this.rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        this.notifyDestroyed();
    }

    private void doCurrentAction() {
        if (this.currentAction.equals("doFirstRun")) {
            this.doFirstRun();
        } else if (this.currentAction.equals("checkForDefaults")) {
            this.checkForDefaults();
        } else if (this.currentAction.equals("newSecret")) {
            this.newSecret();
        } else if (this.currentAction.equals("newManualSecret")) {
            this.newManualSecret();
        } else if (this.currentAction.equals("newAlias")) {
            this.newAlias();
        } else if (this.currentAction.equals("donewPassCode")) {
            this.donewPassCode();
        } else {
            this.mainApp();
        }
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.exitMenuCommand | c == this.exitMainCommand) {
            this.destroyApp(false);
        } else if (c == this.checkForDefaultsNoCommand) {
            this.newSecret();
        } else if (c == this.checkForDefaultsYesCommand) {
            this.LoadDefaults();
        } else if (c == this.backCommand | c == this.cancelCommand) {
            this.doCurrentAction();
        } else if (c == this.timezoneCommand) {
            this.doTimeZone();
        } else if (c == this.tzsaveCommand) {
            this.doTZsave();
        } else if (c == this.aboutMainCommand | c == this.aboutMenuCommand) {
            this.doAboutCommand();
        } else if (c == this.doNextCommand) {
            if (this.nextAction == "newAliasNextCommand") {
                if (this.newalias.length() >= 1) {
                    this.generateInit();
                } else {
                    this.newAlias();
                }
            } else if (this.nextAction == "newManSecNextCommand") {
                if (this.seed.length() < 16) {
                    this.newManualSecret();
                } else {
                    this.newAlias();
                }
            } else if (this.nextAction == "resetNextCommand") {
                this.doresetNext();
            } else if (this.nextAction == "dodeleteSecret") {
                this.dodeleteNext();
            } else if (this.nextAction == "wipeCommand") {
                this.doDBWipe();
            } else if (this.nextAction == "testDefCommand") {
                this.LoadTestDef();
            }
        } else if (c == this.newAliasDeleteCommand) {
            this.donewAliasDeleteCommand();
        } else if (c == this.ManualSecretCommand) {
            this.manualsecret = 1;
            this.seed = "";
            this.newManualSecret();
        } else if (c == this.newManSecDeleteCommand) {
            this.donewManSecDeleteCommand();
        } else if (c == this.newPassCodeCommand) {
            this.donewPassCode();
        } else if (c == this.resetSecretCommand) {
            this.nextAction = "resetNextCommand";
            this.doNext("You are about to reset this shared secret! Make sure this is what you really really want to do!");
        } else if (c == this.deleteSecretCommand) {
            this.nextAction = "dodeleteSecret";
            this.doNext("You are about to delete this shared secret! Make sure this is what you really really want to do!");
        } else if (c == this.mainMenuCommand) {
            this.currentRecord = -1;
            this.initdate = "";
            this.secret = "";
            this.alias = "";
            this.seed = "";
            this.aliasmode = 0L;
            this.mainApp();
        } else if (c == this.wipeCommand) {
            this.nextAction = "wipeCommand";
            this.doNext("Are you sure you want to wipe the phones database?");
        } else if (c == this.testDefCommand) {
            this.nextAction = "testDefCommand";
            this.doNext("Are you sure you want to wipe the phones database, and load the testing defaults?");
        } else if (c == this.selectSecretCommand | c == List.SELECT_COMMAND) {
            this.doselectSecret();
        } else if (c == this.switchCharSetCommand) {
            this.doSwitch();
        } else if (c == this.infoCommand) {
            this.doinfo();
        } else if (c == this.backupCommand) {
            this.dobackupCommand();
        } else if (c == this.restoreCommand) {
            this.dorestoreCommand();
        } else if (c == this.uploadAlert) {
            this.mainApp();
        } else {
            System.out.println("I missed something! " + c);
        }
    }

    private void dorestoreCommand() {
        String tmpStr;
        RSA rsa = new RSA();
        String aeskey = "";
        String aesiv = "";
        String tmpdata = "";
        this.seed = "";
        if (this.usenetwork == "N" | (tmpStr = new String(this.getAppProperty("BackupURI"))).length() <= 0) {
            this.mainApp();
        }
        String username = new String(this.getAppProperty("Username"));
        String password = new String(this.getAppProperty("Password"));
        SecureRandom rand = new SecureRandom();
        for (int x = 0; x <= 1; ++x) {
            this.seed = this.seed + "" + (this.now.getTime() / 10000L + (long)((this.timez - 12) * 360)) / 6L;
            for (int i = 0; i < 100; ++i) {
                this.seed = this.seed + "" + rand.nextInt() * 16384;
            }
            if (x == 0) {
                aeskey = new MD5(this.seed).asHex().substring(0, 32);
                continue;
            }
            aesiv = new MD5(this.seed).asHex().substring(0, 16);
        }
        this.seed = "";
        AES_PBE_BC tmp = new AES_PBE_BC(aeskey.toCharArray(), "".getBytes());
        tmp.setKey(this.hexToChar(aeskey));
        tmp.setIV(aesiv.getBytes());
        tmpdata = username + "|" + password + "|restore|" + aeskey + aesiv;
        String rawdata = rsa.Encrypt(tmpdata, this.modulus);
        String message = "";
        if (!rawdata.equals("")) {
            try {
                message = HTTP.uploadData(tmpStr, rawdata, this.UserAgent);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (message.length() > 32) {
                try {
                    message = tmp.decrypt(message).trim();
                }
                catch (Exception e) {
                    // empty catch block
                }
                tmpStr = message.substring(0, 32);
                message = message.substring(32);
                if (message.length() > 9) {
                    if (tmpStr.equals(new MD5(message).asHex()) & message.substring(0, 9).equals("FreeAuth|")) {
                        try {
                            this.rs.closeRecordStore();
                            RecordStore.deleteRecordStore((String)"FreeAuth.DB");
                            this.rs = RecordStore.openRecordStore((String)"FreeAuth.DB", (boolean)true);
                        }
                        catch (RecordStoreException rse) {
                            // empty catch block
                        }
                        message = message.substring(9);
                        this.timez = Integer.parseInt(message.substring(0, message.indexOf("|")));
                        try {
                            this.rs.addRecord("12".getBytes(), 0, 2);
                            this.rs.setRecord(1, ("" + this.timez).getBytes(), 0, ("" + this.timez).length());
                        }
                        catch (RecordStoreException rse) {
                            // empty catch block
                        }
                        this.totalRecords = 0;
                        this.currentRecord = -1;
                        message = message.substring(message.indexOf("|") + 1);
                        do {
                            try {
                                tmpStr = this.encodeString(message.substring(0, message.indexOf("|")));
                                message = message.substring(message.indexOf("|") + 1);
                                this.rs.addRecord(tmpStr.getBytes(), 0, tmpStr.length());
                                tmpStr = message.substring(0, message.indexOf("|"));
                                message = message.substring(message.indexOf("|") + 1);
                                this.rs.addRecord(tmpStr.getBytes(), 0, tmpStr.length());
                                if (message.indexOf("|") >= 0) {
                                    tmpStr = message.substring(0, message.indexOf("|"));
                                    message = message.substring(message.indexOf("|") + 1);
                                } else {
                                    tmpStr = message;
                                    message = "";
                                }
                                this.rs.addRecord(tmpStr.getBytes(), 0, tmpStr.length());
                            }
                            catch (RecordStoreException rse) {
                                // empty catch block
                            }
                            try {
                                this.totalRecords = (this.rs.getNumRecords() - 1) / 3;
                            }
                            catch (RecordStoreException rse) {
                                // empty catch block
                            }
                        } while (message.length() > 0);
                        this.mainApp();
                        return;
                    }
                    message = "Backup checksum failed to match, possible corruption, man in the middle attack or other problems occurred.";
                } else {
                    message = "Backup checksum failed to match, possible corruption, man in the middle attack or other problems occurred.";
                }
            }
            if (message.equals("")) {
                message = "Failed to connect to restore address.";
            }
        }
        if (message.equals("")) {
            message = "Network connection failure, or network access disabled.";
        }
        Alert soundAlert = new Alert("Upload Error!");
        soundAlert.addCommand(this.uploadAlert);
        soundAlert.setType(AlertType.ERROR);
        soundAlert.setTimeout(-2);
        soundAlert.setCommandListener((CommandListener)this);
        soundAlert.setString(message);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)soundAlert);
    }

    private void dobackupCommand() {
        String tmpStr;
        RSA rsa = new RSA();
        String aeskey = "";
        String aesiv = "";
        String tmpdata = "";
        this.seed = "";
        if (this.usenetwork == "N" | (tmpStr = new String(this.getAppProperty("BackupURI"))).length() <= 0) {
            this.mainApp();
        }
        String username = new String(this.getAppProperty("Username"));
        String password = new String(this.getAppProperty("Password"));
        SecureRandom rand = new SecureRandom();
        for (int x = 0; x <= 1; ++x) {
            this.seed = this.seed + "" + (this.now.getTime() / 10000L + (long)((this.timez - 12) * 360)) / 6L;
            for (int i = 0; i < 100; ++i) {
                this.seed = this.seed + "" + rand.nextInt() * 16384;
            }
            if (x == 0) {
                aeskey = new MD5(this.seed).asHex().substring(0, 32);
                continue;
            }
            aesiv = new MD5(this.seed).asHex().substring(0, 16);
        }
        this.seed = "";
        AES_PBE_BC tmp = new AES_PBE_BC(aeskey.toCharArray(), "".getBytes());
        tmp.setKey(this.hexToChar(aeskey));
        tmp.setIV(aesiv.getBytes());
        tmpdata = username + "|" + password + "|backup|" + aeskey + aesiv;
        String rawdata = rsa.Encrypt(tmpdata, this.modulus);
        tmpdata = "FreeAuth|" + this.timez;
        for (int cr = 2; cr < this.totalRecords * 3; cr += 3) {
            String tmptmp = "";
            try {
                tmptmp = new String(this.rs.getRecord(cr));
            }
            catch (RecordStoreException rse) {
                System.out.println("cr");
            }
            tmpdata = tmptmp.length() > 0 ? tmpdata + "|" + this.decodeString(tmptmp.getBytes()) : tmpdata + "|" + new MD5(tmpStr).asHex();
            try {
                tmpdata = tmpdata + "|" + new String(this.rs.getRecord(cr + 1));
            }
            catch (RecordStoreException rse) {
                System.out.println("cr+1");
            }
            try {
                tmpdata = tmpdata + "|" + new String(this.rs.getRecord(cr + 2));
                continue;
            }
            catch (RecordStoreException rse) {
                System.out.println("cr+2");
            }
        }
        try {
            tmpdata = tmp.encrypt(new MD5(tmpdata).asHex() + tmpdata);
            rawdata = rawdata + "\n\n" + tmpdata;
        }
        catch (Exception e) {
            System.out.println("here again...");
            rawdata = "";
        }
        String message = "";
        if (!rawdata.equals("")) {
            try {
                message = HTTP.uploadData(tmpStr, rawdata, this.UserAgent);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (message.length() > 0 && message.substring(0, 1).equals("0")) {
                System.out.println("Uploaded!!");
                return;
            }
            if (message.equals("")) {
                message = "Failed to connect to upload address.";
            }
        }
        if (message.equals("")) {
            message = "Network connection failure, or network access disabled.";
        }
        Alert soundAlert = new Alert("Upload Error!");
        soundAlert.addCommand(this.uploadAlert);
        soundAlert.setType(AlertType.ERROR);
        soundAlert.setTimeout(-2);
        soundAlert.setCommandListener((CommandListener)this);
        soundAlert.setString(message);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)soundAlert);
    }

    private void doSwitch() {
        this.OTPbits = this.OTPbits == 64 ? 32 : 64;
        this.doCurrentAction();
    }

    private void doinfo() {
        this.now = new Date();
        this.epoch = "" + (this.now.getTime() + (long)((this.timez - 12) * 3600000));
        this.epoch = this.epoch.substring(0, this.epoch.length() - 4);
        this.lowinput = new Canvas(){

            public void paint(Graphics g) {
                int w = this.getWidth();
                int h = this.getHeight();
                g.setColor(255, 255, 255);
                g.fillRect(0, 0, w, h);
                g.setColor(0, 0, 0);
                g.drawString("Epoch-Time:", 1, 1, 0);
                g.drawString(FreeAuth.this.epoch, 1, 1 + h / 5, 0);
                g.drawString("Initialization:", 1, 1 + 2 * h / 5, 0);
                g.drawString(FreeAuth.this.initdate, 1, 1 + 3 * h / 5, 0);
            }
        };
        this.lowinput.addCommand(this.backCommand);
        this.lowinput.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.lowinput);
    }

    private void doselectSecret() {
        Display display = Display.getDisplay((MIDlet)this);
        List options = (List)display.getCurrent();
        int option = options.getSelectedIndex();
        if (option > 0) {
            this.alias = "";
            this.initdate = "";
            this.secret = "";
            try {
                String tmpStr = "";
                this.currentRecord = (option - 1) * 3;
                try {
                    tmpStr = new String(this.rs.getRecord(this.currentRecord + 2));
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                this.secret = tmpStr.length() >= 16 ? this.decodeString(tmpStr.getBytes()) : new MD5(tmpStr).asHex();
                this.secret = this.secret.substring(0, 16);
                this.initdate = new String(this.rs.getRecord(this.currentRecord + 3));
                this.alias = new String(this.rs.getRecord(this.currentRecord + 4));
                System.out.println("Hash loaded from slot" + (this.currentRecord / 3 + 1));
                System.out.println("Alias: " + this.alias);
                this.donewPassCode();
            }
            catch (RecordStoreException rse) {
                System.out.println("RS Error! Read");
            }
        } else {
            this.newSecret();
        }
    }

    private void mainApp() {
        this.currentAction = "mainApp";
        if (this.search.length() > 0) {
            System.out.println("Search: '" + this.search + "'");
        }
        List options = new List("Select Secret", 3);
        options.append("New Shared Secret", null);
        for (int loop = 0; loop < this.totalRecords; ++loop) {
            int recnum = loop * 3 + 4;
            try {
                this.alias = new String(this.rs.getRecord(recnum));
                if (this.search.length() > 0 && !this.alias.startsWith(this.search)) {
                    continue;
                }
            }
            catch (RecordStoreException rse) {
                System.out.println("RS Error! Read");
            }
            options.append(this.alias, null);
        }
        options.addCommand(this.exitMainCommand);
        options.addCommand(this.selectSecretCommand);
        options.addCommand(this.aboutMainCommand);
        options.addCommand(this.timezoneCommand);
        options.addCommand(this.backupCommand);
        options.addCommand(this.restoreCommand);
        options.addCommand(this.wipeCommand);
        options.addCommand(this.testDefCommand);
        options.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)options);
    }

    public void startApp() {
        this.currentAction = "startApp";
        try {
            this.rs = RecordStore.openRecordStore((String)"FreeAuth.DB", (boolean)true);
            this.totalRecords = this.rs.getNumRecords();
        }
        catch (RecordStoreException rse) {
            System.out.println("RS Error! Open");
        }
        this.lowinput = new Canvas(){

            public void paint(Graphics g) {
                int w = this.getWidth();
                int h = this.getHeight();
                if (FreeAuth.this.PIN.length() < 8) {
                    if (FreeAuth.this.totalRecords <= 0) {
                        FreeAuth.this.showString(h, w, g, "Please enter a secret PIN to encrypt all your information with.");
                    } else {
                        FreeAuth.this.showString(h, w, g, "Please enter your secret PIN to decrypt all your information with.");
                    }
                    g.drawString("PIN: " + FreeAuth.this.pindis, 1, h - 20, 0);
                } else {
                    FreeAuth.this.showString(h, w, g, "Please wait while this applet initalises the Cyrptography Engine.");
                    FreeAuth.this.displayTimer();
                }
            }

            protected void keyPressed(int keyCode) {
                if (keyCode >= 48 & keyCode <= 57) {
                    FreeAuth.this.PIN = FreeAuth.this.PIN + String.valueOf((char)keyCode);
                    if (FreeAuth.this.PIN.length() < 8) {
                        FreeAuth.this.pindis = FreeAuth.this.pindis + "*";
                    } else {
                        FreeAuth.this.pindis = FreeAuth.this.pindis + "*";
                        FreeAuth.this.PIN = FreeAuth.this.PIN.substring(0, 8);
                    }
                }
                this.repaint();
            }
        };
        this.lowinput.addCommand(this.exitMainCommand);
        this.lowinput.addCommand(this.aboutMainCommand);
        this.lowinput.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.lowinput);
    }

    private void displayTimer() {
        System.out.println("Starting timer and waiting 25ms, should be enough for the display to refresh.");
        this.timer = new Timer();
        this.updateTask = new TimerTask(){

            public void run() {
                System.out.println("Cancelling timer and jumping.");
                FreeAuth.this.timer.cancel();
                FreeAuth.this.dostartNext();
            }
        };
        long interval = 25L;
        this.timer.schedule(this.updateTask, interval, interval);
    }

    private void checkDB() {
        this.firstRun = 0;
        if (this.totalRecords <= 0) {
            this.firstRun = 1;
        }
        if (this.totalRecords <= 0) {
            try {
                this.rs.addRecord("12".getBytes(), 0, "12".length());
            }
            catch (RecordStoreException rse) {
                System.out.println("Failed to add timez to RMS");
            }
        }
        if (this.firstRun == 0) {
            this.totalRecords = (this.totalRecords - 1) / 3;
            try {
                this.tmpbuf = new String(this.rs.getRecord(1));
                System.out.println("Before: " + this.tmpbuf);
                this.timez = Integer.parseInt(this.tmpbuf);
                System.out.println("Timez: " + this.timez);
            }
            catch (NumberFormatException err) {
                System.out.println("Corrupted DB!");
                this.timez = -9;
            }
            catch (RecordStoreException rse) {
                System.out.println("Empty DB!");
                this.timez = -9;
            }
        }
        if (this.timez < -1 | this.timez > 25) {
            this.timez = 12;
            this.firstRun = 1;
            this.totalRecords = 0;
            try {
                this.rs.closeRecordStore();
                RecordStore.deleteRecordStore((String)"FreeAuth.DB");
                this.rs = RecordStore.openRecordStore((String)"FreeAuth.DB", (boolean)true);
            }
            catch (RecordStoreException rse) {
                System.out.println("RS Error! Open");
            }
        }
        if (this.totalRecords == 1) {
            try {
                this.currentRecord = 0;
                this.secret = this.decodeString(this.rs.getRecord(2));
                this.secret = this.secret.substring(0, 16);
                this.initdate = new String(this.rs.getRecord(3));
                this.alias = new String(this.rs.getRecord(4));
                System.out.println("Hash loaded from slot" + (this.currentRecord / 3 + 1));
                System.out.println("Alias: " + this.alias);
            }
            catch (RecordStoreException rse) {
                System.out.println("RS Error during preload");
            }
        }
        if (this.totalRecords == 1) {
            this.donewPassCode();
            this.mainApp();
        } else if (this.firstRun != 0) {
            this.checkTS();
            this.doFirstRun();
        } else {
            this.mainApp();
        }
    }

    private void dostartNext() {
        if (this.PIN.length() >= 8) {
            String DBPIN = this.PIN.substring(0, 8);
            this.pindis = "";
            this.PIN = "";
            int hasCrypto = 0;
            int oldRecords = 0;
            RecordStore oldrs = null;
            try {
                this.meta = RecordStore.openRecordStore((String)"FreeAuth.META", (boolean)true);
                hasCrypto = this.meta.getNumRecords();
                if (hasCrypto >= 1) {
                    this.secretdecode = new AES_PBE_BC(DBPIN.toCharArray(), this.meta.getRecord(1));
                }
                if (this.totalRecords <= 0) {
                    oldrs = RecordStore.openRecordStore((String)"FreeAuth", (boolean)false);
                    oldRecords = oldrs.getNumRecords();
                }
            }
            catch (RecordStoreException rse) {
                System.out.println("RS Error! Open");
            }
            if (this.totalRecords <= 0 & hasCrypto <= 0 & oldRecords > 0) {
                try {
                    this.secretdecode = new AES_PBE_BC(DBPIN.toCharArray(), "".getBytes());
                    this.meta.addRecord(this.secretdecode.getSalt(), 0, 8);
                    for (int i = 1; i <= oldRecords; ++i) {
                        this.tmpbuf = (i - 2) / 3 == 0 ? this.encodeString(new String(oldrs.getRecord(i))) : new String(oldrs.getRecord(i));
                        this.rs.addRecord(this.tmpbuf.getBytes(), 0, this.tmpbuf.length());
                    }
                    oldrs.closeRecordStore();
                    RecordStore.deleteRecordStore((String)"FreeAuth");
                    this.totalRecords = this.rs.getNumRecords();
                }
                catch (RecordStoreException rse) {
                    // empty catch block
                }
            }
            if (this.totalRecords > 0) {
                DBPIN = "";
                this.checkDB();
            } else {
                try {
                    this.secretdecode = new AES_PBE_BC(DBPIN.toCharArray(), "".getBytes());
                    this.meta.addRecord(this.secretdecode.getSalt(), 0, 8);
                    this.checkDB();
                }
                catch (RecordStoreException rse) {}
            }
        } else {
            this.startApp();
        }
    }

    private void doresetNext() {
        this.secret = "";
        this.aliasmode = 1L;
        this.newSecret();
    }

    private void dodeleteNext() {
        this.pindis = "";
        this.PIN = "";
        this.seed = "";
        this.secret = "";
        this.alias = "";
        this.aliasmode = 0L;
        try {
            int i;
            int j = 0;
            String[] tmpsecret = new String[this.totalRecords - 1];
            String[] tmpdate = new String[this.totalRecords - 1];
            String[] tmpalias = new String[this.totalRecords - 1];
            System.out.println("Need to delete: " + this.currentRecord);
            for (i = 2; i < this.totalRecords * 3; i += 3) {
                System.out.println("Trying: " + i);
                if (i != this.currentRecord + 2) {
                    tmpsecret[j] = new String(this.rs.getRecord(i));
                    tmpdate[j] = new String(this.rs.getRecord(i + 1));
                    tmpalias[j] = new String(this.rs.getRecord(i + 2));
                    System.out.println("Alias: " + tmpalias[j]);
                    ++j;
                    continue;
                }
                System.out.println("Skipped " + i + " due to deletion!");
            }
            --j;
            this.rs.closeRecordStore();
            RecordStore.deleteRecordStore((String)"FreeAuth.DB");
            this.rs = RecordStore.openRecordStore((String)"FreeAuth.DB", (boolean)true);
            this.rs.addRecord("12".getBytes(), 0, "12".length());
            this.rs.setRecord(1, ("" + this.timez).getBytes(), 0, ("" + this.timez).length());
            for (i = 0; i <= j; ++i) {
                this.rs.addRecord(tmpsecret[i].getBytes(), 0, tmpsecret[i].length());
                this.rs.addRecord(tmpdate[i].getBytes(), 0, tmpdate[i].length());
                this.rs.addRecord(tmpalias[i].getBytes(), 0, tmpalias[i].length());
            }
            this.currentRecord = -1;
            --this.totalRecords;
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        this.mainApp();
    }

    private void doNext(final String message) {
        this.lowinput = new Canvas(){

            public void paint(Graphics g) {
                int w = this.getWidth();
                int h = this.getHeight();
                FreeAuth.this.showString(h, w, g, message);
            }
        };
        this.lowinput.addCommand(this.cancelCommand);
        this.lowinput.addCommand(this.doNextCommand);
        this.lowinput.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.lowinput);
    }

    private void donewPassCode() {
        this.currentAction = "donewPassCode";
        this.lowinput = new Canvas(){

            public void paint(Graphics g) {
                g.setColor(255, 255, 255);
                int w = this.getWidth();
                int h = this.getHeight();
                g.fillRect(0, 0, w, h);
                g.setColor(0, 0, 0);
                g.drawString("Site: " + FreeAuth.this.alias, 1, 1, 0);
                FreeAuth.this.now = new Date();
                FreeAuth.this.epoch = "" + (FreeAuth.this.now.getTime() / 10000L + (long)((FreeAuth.this.timez - 12) * 360)) / 6L;
                long dispepoch = FreeAuth.this.now.getTime() / 1000L + (long)((FreeAuth.this.timez - 12) * 3600);
                dispepoch -= (long)((int)(dispepoch / 60L) * 60);
                dispepoch = 59L - dispepoch;
                String otp = FreeAuth.this.epoch + FreeAuth.this.secret;
                MD5 hash = new MD5(otp);
                otp = FreeAuth.this.OTPbits == 64 ? FreeAuth.this.getOTP64(hash.asHex()) : FreeAuth.this.getOTP32(hash.asHex());
                g.drawString("PassCode: " + otp, 1, 30, 0);
                g.drawString("Next PassCode: " + dispepoch, 1, 50, 0);
            }
        };
        this.lowinput.addCommand(this.mainMenuCommand);
        this.lowinput.addCommand(this.timezoneCommand);
        this.lowinput.addCommand(this.switchCharSetCommand);
        this.lowinput.addCommand(this.infoCommand);
        this.lowinput.addCommand(this.resetSecretCommand);
        this.lowinput.addCommand(this.deleteSecretCommand);
        this.lowinput.addCommand(this.aboutMenuCommand);
        this.lowinput.addCommand(this.exitMenuCommand);
        this.lowinput.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.lowinput);
        this.startTimer();
    }

    protected void startTimer() {
        this.timer = new Timer();
        this.updateTask = new TimerTask(){

            public void run() {
                if (FreeAuth.this.lowinput != null) {
                    FreeAuth.this.lowinput.repaint();
                }
            }
        };
        long interval = 1000L;
        this.timer.schedule(this.updateTask, interval, interval);
    }

    protected void stopFrameTimer() {
        this.timer.cancel();
    }

    private void doFirstRun() {
        System.out.println("FirstRun()!");
        this.currentAction = "doFirstRun";
        this.lowinput = new Canvas(){

            public void paint(Graphics g) {
                int w = this.getWidth();
                int h = this.getHeight();
                g.setColor(255, 255, 255);
                g.fillRect(0, 0, w, h);
                FreeAuth.this.showString(h, w, g, "Welcome to the FreeAuth Project java MIDLet. Press any key to continue.");
            }

            protected void keyPressed(int keyCode) {
                if (keyCode >= 32) {
                    FreeAuth.this.checkForDefaults();
                }
            }
        };
        this.lowinput.addCommand(this.exitMainCommand);
        this.lowinput.addCommand(this.aboutMainCommand);
        this.lowinput.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.lowinput);
    }

    private void donewAliasDeleteCommand() {
        if (this.newalias.length() > 0) {
            this.newalias = this.newalias.substring(0, this.newalias.length() - 1);
        }
        this.newAlias();
    }

    private void donewManSecDeleteCommand() {
        if (this.seed.length() > 0) {
            this.seed = this.seed.substring(0, this.seed.length() - 1);
        }
        this.newManualSecret();
    }

    private void newAlias() {
        this.currentAction = "newAlias";
        this.lowinput = new Canvas(){

            public void paint(Graphics g) {
                int w = this.getWidth();
                int h = this.getHeight();
                g.setColor(255, 255, 255);
                g.fillRect(0, 0, w, h);
                FreeAuth.this.showString(h - 40, w, g, "You now need to enter an alias for your new shared secret.");
                g.drawString("Alias: " + FreeAuth.this.newalias, 1, h - 20, 0);
            }

            protected void keyPressed(int keyCode) {
                if (keyCode >= 32) {
                    FreeAuth.this.newalias = FreeAuth.this.checkKey((char)keyCode, FreeAuth.this.newalias);
                }
                this.repaint();
            }
        };
        this.nextAction = "newAliasNextCommand";
        this.lowinput.addCommand(this.newAliasDeleteCommand);
        this.lowinput.addCommand(this.doNextCommand);
        this.lowinput.addCommand(this.aboutMenuCommand);
        this.lowinput.addCommand(this.exitMenuCommand);
        this.lowinput.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.lowinput);
        if (this.aliasmode > 0L) {
            this.generateInit();
        }
    }

    private void generateInit() {
        this.currentAction = "generateInit";
        if (this.secret == "") {
            if (this.manualsecret == 0) {
                char[] charset = "123456789abcdefhkmnprstuvwxyzABCDEFGHKMNPQRSTUVWXYZ=+[]&@#*!-?%:".toCharArray();
                this.secret = "";
                SecureRandom rand = new SecureRandom();
                this.seed = this.seed + "" + (this.now.getTime() / 10000L + (long)((this.timez - 12) * 360)) / 6L;
                for (int i = 0; i < 100; ++i) {
                    this.seed = this.seed + "" + rand.nextInt() * 16384;
                }
                char[] vals = this.hexToChar(new MD5(this.seed).asHex());
                for (int i = 0; i < 16; ++i) {
                    int j;
                    for (j = vals[i] >> 2; j > 63; j -= 64) {
                    }
                    this.secret = this.secret + charset[j];
                }
            } else {
                this.secret = this.seed.substring(0, 16);
            }
            this.cnow = Calendar.getInstance();
            String day = "" + this.cnow.get(5);
            String month = "" + (this.cnow.get(2) + 1);
            String hour = "" + this.cnow.get(10);
            String minute = "" + this.cnow.get(12);
            String year = "" + this.cnow.get(1);
            if (day.length() < 2) {
                day = "0" + day;
            }
            if (month.length() < 2) {
                month = "0" + month;
            }
            if (hour.length() < 2) {
                hour = "0" + hour;
            }
            if (minute.length() < 2) {
                minute = "0" + minute;
            }
            if (year.length() < 2) {
                year = "0" + year;
            }
            this.initdate = year + month + day + hour + minute;
            try {
                if (this.currentRecord == -1) {
                    ++this.totalRecords;
                    this.currentRecord = this.totalRecords * 3 - 3;
                    this.alias = this.newalias;
                    if (this.newalias.length() <= 0) {
                        this.alias = "Dummy Alias";
                    }
                    if (this.alias.length() > 16) {
                        this.alias = this.alias.substring(0, 16);
                    }
                    this.tmpbuf = this.encodeString(this.secret);
                    this.rs.addRecord(this.tmpbuf.getBytes(), 0, this.tmpbuf.length());
                    this.rs.addRecord(this.initdate.getBytes(), 0, this.initdate.length());
                    this.rs.addRecord(this.alias.getBytes(), 0, this.alias.length());
                    System.out.println("New hash generated, stored in slot" + this.totalRecords);
                    System.out.println("Alias: " + this.alias);
                } else {
                    if (this.newalias.length() > 0 & this.aliasmode == 0L) {
                        this.alias = this.newalias;
                        this.alias = this.alias.substring(0, 16);
                        this.rs.setRecord(this.currentRecord + 4, this.alias.getBytes(), 0, this.alias.length());
                    }
                    this.tmpbuf = this.encodeString(this.secret);
                    this.rs.setRecord(this.currentRecord + 2, this.tmpbuf.getBytes(), 0, this.tmpbuf.length());
                    System.out.println("Hash reset, stored in slot" + (this.currentRecord / 3 + 1));
                    System.out.println("Alias: " + this.alias);
                }
                this.seed = "";
                this.newalias = "";
                this.PIN = "";
                this.aliasmode = 0L;
            }
            catch (RecordStoreException rse) {
                System.out.println("RS Error! Write");
            }
        }
        this.lowinput = new Canvas(){

            public void paint(Graphics g) {
                g.setColor(255, 255, 255);
                int w = this.getWidth();
                int h = this.getHeight();
                g.fillRect(0, 0, w, h);
                g.setColor(0, 0, 0);
                g.drawString("Init-Secret=", w / 7, h / 3 - 2, 0);
                g.drawString(FreeAuth.this.secret.substring(0, 8), w / 6, h / 2, 0);
                g.drawString(FreeAuth.this.secret.substring(8, 16), w / 6, h / 2 + h / 5, 0);
            }
        };
        this.lowinput.addCommand(this.mainMenuCommand);
        this.lowinput.addCommand(this.newPassCodeCommand);
        this.lowinput.addCommand(this.aboutMenuCommand);
        this.lowinput.addCommand(this.exitMenuCommand);
        this.lowinput.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.lowinput);
    }

    private void newManualSecret() {
        this.currentAction = "newManualSecret";
        this.lowinput = new Canvas(){

            public void paint(Graphics g) {
                int max;
                int w = this.getWidth();
                int h = this.getHeight();
                g.setColor(255, 255, 255);
                g.fillRect(0, 0, w, h);
                FreeAuth.this.showString(40, w, g, "Please enter your shared secret.");
                if (FreeAuth.this.seed.length() > 0) {
                    max = 8;
                    if (FreeAuth.this.seed.length() < max) {
                        max = FreeAuth.this.seed.length();
                    }
                    g.drawString(FreeAuth.this.seed.substring(0, max), 1, 60, 0);
                }
                if (FreeAuth.this.seed.length() > 8) {
                    max = 16;
                    if (FreeAuth.this.seed.length() < max) {
                        max = FreeAuth.this.seed.length();
                    }
                    g.drawString(FreeAuth.this.seed.substring(8, max), 1, 80, 0);
                }
            }

            protected void keyPressed(int keyCode) {
                if (keyCode >= 32) {
                    FreeAuth.this.seed = FreeAuth.this.checkKey((char)keyCode, FreeAuth.this.seed);
                }
                if (FreeAuth.this.seed.length() > 16) {
                    FreeAuth.this.seed = FreeAuth.this.seed.substring(0, 16);
                }
                this.repaint();
            }
        };
        this.nextAction = "newManSecNextCommand";
        this.lowinput.addCommand(this.newManSecDeleteCommand);
        this.lowinput.addCommand(this.doNextCommand);
        this.lowinput.addCommand(this.aboutMenuCommand);
        this.lowinput.addCommand(this.exitMenuCommand);
        this.lowinput.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.lowinput);
    }

    private void newSecret() {
        this.currentAction = "newSecret";
        int rsAvailable = 0;
        try {
            rsAvailable = this.rs.getSizeAvailable();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        if (rsAvailable > 100 | this.currentRecord >= 0) {
            this.lowinput = new Canvas(){

                public void paint(Graphics g) {
                    int w = this.getWidth();
                    int h = this.getHeight();
                    g.setColor(255, 255, 255);
                    g.fillRect(0, 0, w, h);
                    FreeAuth.this.showString(h - 40, w, g, "You now need to press 20 random keys to generate a new shared secret.");
                    g.drawString("Keys to go: " + (20 - FreeAuth.this.seed.length()), 1, h - 20, 0);
                }

                protected void keyPressed(int keyCode) {
                    if (keyCode >= 32) {
                        FreeAuth.this.seed = FreeAuth.this.seed + String.valueOf((char)keyCode);
                        if (FreeAuth.this.seed.length() >= 20 & FreeAuth.this.aliasmode == 0L) {
                            FreeAuth.this.newAlias();
                        } else if (FreeAuth.this.seed.length() >= 20) {
                            FreeAuth.this.generateInit();
                        } else {
                            this.repaint();
                        }
                    }
                }
            };
            this.lowinput.addCommand(this.mainMenuCommand);
            this.lowinput.addCommand(this.ManualSecretCommand);
            this.lowinput.addCommand(this.aboutMenuCommand);
            this.lowinput.addCommand(this.exitMenuCommand);
            this.lowinput.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.lowinput);
        } else {
            this.lowinput = new Canvas(){

                public void paint(Graphics g) {
                    int w = this.getWidth();
                    int h = this.getHeight();
                    g.setColor(255, 255, 255);
                    g.fillRect(0, 0, w, h);
                    FreeAuth.this.showString(h, w, g, "You don't have enough space in your phone to create a new record, please delete 1 or more entries.");
                }
            };
            this.lowinput.addCommand(this.cancelCommand);
            this.lowinput.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.lowinput);
        }
    }

    private void showString(int h, int w, Graphics g, String tmpstr) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, w, h);
        g.setColor(0, 0, 0);
        int cw = w / 7;
        int lines = tmpstr.length() * 7 / w;
        int top = h / 2 - lines * 20 / 2;
        for (int i = 0; i <= lines; ++i) {
            int max = (i + 1) * cw;
            if (tmpstr.length() < max) {
                max = tmpstr.length();
            }
            g.drawString(tmpstr.substring(i * cw, max), 1, top + i * 20, 0);
        }
    }

    private void checkForDefaults() {
        this.currentAction = "checkForDefaults";
        String defhash = "";
        String defalias = "";
        try {
            defhash = new String(this.getAppProperty("hash"));
        }
        catch (NullPointerException err) {
            // empty catch block
        }
        try {
            defalias = new String(this.getAppProperty("alias"));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (defhash.length() != 16 | defalias.length() <= 0) {
            this.newSecret();
        } else {
            this.lowinput = new Canvas(){

                public void paint(Graphics g) {
                    int w = this.getWidth();
                    int h = this.getHeight();
                    FreeAuth.this.showString(h, w, g, "There is a default secret and alias. Press Yes if you wish to load these or No to skip these.");
                }
            };
            this.lowinput.addCommand(this.checkForDefaultsNoCommand);
            this.lowinput.addCommand(this.checkForDefaultsYesCommand);
            this.lowinput.addCommand(this.aboutMenuCommand);
            this.lowinput.addCommand(this.exitMenuCommand);
            this.lowinput.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.lowinput);
        }
    }

    private void LoadDefaults() {
        String defhash = "";
        String defalias = "";
        try {
            defhash = new String(this.getAppProperty("hash"));
        }
        catch (NullPointerException err) {
            // empty catch block
        }
        try {
            defalias = new String(this.getAppProperty("alias"));
        }
        catch (NullPointerException err) {
            // empty catch block
        }
        try {
            this.timez = 12 + Integer.parseInt(new String(this.getAppProperty("timez")));
        }
        catch (NullPointerException err) {
            // empty catch block
        }
        this.alias = defalias;
        this.secret = defhash;
        this.cnow = Calendar.getInstance();
        String day = "" + this.cnow.get(5);
        String month = "" + (this.cnow.get(2) + 1);
        String hour = "" + this.cnow.get(10);
        String minute = "" + this.cnow.get(12);
        String year = "" + this.cnow.get(1);
        if (day.length() < 2) {
            day = "0" + day;
        }
        if (month.length() < 2) {
            month = "0" + month;
        }
        if (hour.length() < 2) {
            hour = "0" + hour;
        }
        if (minute.length() < 2) {
            minute = "0" + minute;
        }
        if (year.length() < 2) {
            year = "0" + year;
        }
        this.initdate = year + month + day + hour + minute;
        try {
            if (this.alias.length() > 16) {
                this.alias = this.alias.substring(0, 16);
            }
            this.rs.setRecord(1, ("" + this.timez).getBytes(), 0, ("" + this.timez).length());
            this.tmpbuf = this.encodeString(this.secret);
            this.rs.addRecord(this.tmpbuf.getBytes(), 0, this.tmpbuf.length());
            this.rs.addRecord(this.initdate.getBytes(), 0, this.initdate.length());
            this.rs.addRecord(this.alias.getBytes(), 0, this.alias.length());
            System.out.println("New hash generated, stored in slot1");
            System.out.println("Alias: " + this.alias);
        }
        catch (RecordStoreException rse) {
            System.out.println("RS Error! Write");
        }
        this.currentRecord = 0;
        this.totalRecords = 1;
        this.donewPassCode();
    }

    private void doTimeZone() {
        this.lowinput = new Canvas(){

            public void paint(Graphics g) {
                FreeAuth.this.now = new Date();
                FreeAuth.this.epoch = "" + (FreeAuth.this.now.getTime() / 10000L + (long)((FreeAuth.this.timez - 12) * 360)) / 6L;
                int w = this.getWidth();
                int h = this.getHeight();
                g.setColor(255, 255, 255);
                g.fillRect(0, 0, w, h);
                g.setColor(0, 0, 0);
                g.drawString("Set Time Zone=", 1, 1, 0);
                if (FreeAuth.this.timez > 12) {
                    g.drawString("UTC" + (12 - FreeAuth.this.timez), 1, 20, 0);
                } else {
                    g.drawString("UTC+" + (12 - FreeAuth.this.timez), 1, 40, 0);
                }
                g.drawString("Epoch  Time: " + FreeAuth.this.epoch, 1, 60, 0);
                if (FreeAuth.this.usenetwork == "Y" & FreeAuth.this.serverepoch > 0L & FreeAuth.this.serverts > 0L) {
                    long tsdiff = FreeAuth.this.serverepoch + FreeAuth.this.now.getTime() / 60000L - FreeAuth.this.serverts;
                    g.drawString("FreeAuth Time: " + tsdiff, 1, 80, 0);
                }
            }

            protected void keyPressed(int keyCode) {
                if ((keyCode = this.getGameAction(keyCode)) == 49 | keyCode == 52 | keyCode == 55 | keyCode == 42 | keyCode == 2 | keyCode == 6) {
                    FreeAuth.this.timez++;
                }
                if (keyCode == 51 | keyCode == 54 | keyCode == 57 | keyCode == 35 | keyCode == 5 | keyCode == 1) {
                    FreeAuth.this.timez--;
                }
                if (FreeAuth.this.timez < -1) {
                    FreeAuth.this.timez = -1;
                }
                if (FreeAuth.this.timez > 25) {
                    FreeAuth.this.timez = 25;
                }
                this.repaint();
            }
        };
        this.lowinput.addCommand(this.cancelCommand);
        this.lowinput.addCommand(this.tzsaveCommand);
        this.lowinput.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.lowinput);
    }

    private void doTZsave() {
        try {
            this.rs.setRecord(1, ("" + this.timez).getBytes(), 0, ("" + this.timez).length());
        }
        catch (RecordStoreException rse) {
            System.out.println("RS Error! Write");
        }
        if (this.usenetwork == "Y" & this.serverepoch > 0L & this.serverts > 0L) {
            long tsdiff;
            this.now = new Date();
            this.epoch = "" + (this.now.getTime() / 10000L + (long)((this.timez - 12) * 360)) / 6L;
            long tmpepoch = Long.parseLong(this.epoch);
            if (tmpepoch - 6L >= (tsdiff = this.serverepoch + this.now.getTime() / 60000L - this.serverts) | tmpepoch + 6L <= tsdiff) {
                System.out.println("Clock skew in phone detected!");
            }
        }
        this.doCurrentAction();
    }

    private void doAboutCommand() {
        this.lowinput = new Canvas(){

            public void paint(Graphics g) {
                int w = this.getWidth();
                int h = this.getHeight();
                g.setColor(255, 255, 255);
                g.fillRect(0, 0, w, h);
                g.setColor(0, 0, 0);
                g.drawString(new String(FreeAuth.this.getAppProperty("MIDlet-Name")) + " is based on", 3, 3, 0);
                g.drawString("MobileOTP v 1.0.6", 3, 20, 0);
                g.drawString("(c) 2003, 2004", 3, 40, 0);
                g.drawString("M. Straub", 3, 60, 0);
                g.drawString(FreeAuth.this.UserAgent, 3, 80, 0);
                g.drawString("(c) 2007", 3, 100, 0);
                g.drawString("Free Auth Project", 3, 120, 0);
                try {
                    int tmpused = FreeAuth.this.rs.getSize() / (FreeAuth.this.rs.getSize() + FreeAuth.this.rs.getSizeAvailable()) * 100;
                    g.drawString(tmpused + "% used (" + FreeAuth.this.rs.getSize() + "/" + (FreeAuth.this.rs.getSize() + FreeAuth.this.rs.getSizeAvailable()) + ")", 3, 140, 0);
                    g.drawString(FreeAuth.this.rs.getNumRecords() + " records stored", 3, 160, 0);
                }
                catch (RecordStoreException rse) {
                    // empty catch block
                }
            }
        };
        this.lowinput.addCommand(this.backCommand);
        this.lowinput.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.lowinput);
    }

    private void checkTS() {
        if (this.serverts == 0L | this.serverepoch == 0L) {
            String tmpnetwork = "Y";
            try {
                tmpnetwork = new String(this.getAppProperty("UseNetwork"));
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            this.usenetwork = tmpnetwork.startsWith("N") | tmpnetwork.startsWith("n") ? "N" : "Y";
            if (this.usenetwork == "Y") {
                HTTP newconn = new HTTP();
                String sURL = new String(this.getAppProperty("TimeStampURI"));
                String message = HTTP.getTimeStamp(sURL, this.UserAgent);
                if (!message.equals("")) {
                    this.now = new Date();
                    this.epoch = "" + (this.now.getTime() / 10000L + (long)((this.timez - 12) * 360)) / 6L;
                    this.serverts = this.now.getTime() / 60000L;
                    this.serverepoch = Long.parseLong(message);
                    long tmpepoch = Long.parseLong(this.epoch);
                    System.out.println("Current timestamp: " + this.epoch);
                    System.out.println("Server timestamp: " + this.serverepoch);
                    System.out.println(tmpepoch - 6L + " <= " + this.serverepoch + " <= " + (tmpepoch + 6L));
                    if (tmpepoch - 6L >= this.serverepoch | tmpepoch + 6L <= this.serverepoch) {
                        System.out.println("Clock skew in phone detected! Attempting to correct!");
                        for (int i = -1; i <= 25; ++i) {
                            tmpepoch = (this.now.getTime() / 10000L + (long)((this.timez - 12) * 360)) / 6L;
                            if (!(tmpepoch - 6L >= this.serverepoch | tmpepoch + 6L <= this.serverepoch)) continue;
                            this.timez = i;
                            int tr = -9;
                            try {
                                tr = this.rs.getNumRecords();
                            }
                            catch (RecordStoreException rse) {
                                System.out.println("RS Error! Failed to update time zone");
                            }
                            try {
                                this.rs.setRecord(1, ("" + this.timez).getBytes(), 0, ("" + this.timez).length());
                                continue;
                            }
                            catch (RecordStoreException rse) {
                                System.out.println("RS Error! Failed to update time zone");
                            }
                        }
                    }
                } else {
                    this.usenetwork = "N";
                }
            }
        }
        try {
            if (this.rs.getNumRecords() <= 0) {
                this.rs.addRecord("12".getBytes(), 0, "12".length());
            }
        }
        catch (RecordStoreException rse) {
            System.out.println("RS Error! Failed to update time zone");
        }
    }

    private char[] hexToChar(String hex) {
        char[] kDigits = "0123456789abcdef".toCharArray();
        int length = hex.length() / 2;
        char[] raw = new char[length];
        for (int i = 0; i < length; ++i) {
            int high = Character.digit(hex.charAt(i * 2), 16);
            int low = Character.digit(hex.charAt(i * 2 + 1), 16);
            int value = high << 4 | low;
            raw[i] = (char)value;
        }
        return raw;
    }

    private String getOTP64(String hash) {
        char[] charset = "123456789abcdefhkmnprstuvwxyzABCDEFGHKMNPQRSTUVWXYZ=+[]&@#*!-?%:".toCharArray();
        String retbuf = "";
        int tmp2 = 0;
        char[] vals = this.hexToChar(hash);
        int tmp1 = vals[0] >> 2;
        retbuf = retbuf + charset[tmp1 & 0x3F];
        tmp2 = vals[0] - (tmp1 << 2);
        tmp1 = vals[1] >> 4;
        retbuf = retbuf + charset[tmp1 + tmp2 & 0x3F];
        tmp2 = vals[1] - (tmp1 << 4);
        tmp1 = vals[2] >> 6;
        retbuf = retbuf + charset[tmp1 + tmp2 & 0x3F];
        tmp2 = vals[2] - (tmp1 << 6);
        retbuf = retbuf + charset[tmp2 & 0x3F];
        tmp1 = vals[3] >> 2;
        retbuf = retbuf + charset[tmp1 & 0x3F];
        tmp2 = vals[3] - (tmp1 << 2);
        tmp1 = vals[4] >> 4;
        retbuf = retbuf + charset[tmp1 + tmp2 & 0x3F];
        tmp2 = vals[4] - (tmp1 << 4);
        tmp1 = vals[5] >> 6;
        retbuf = retbuf + charset[tmp1 + tmp2 & 0x3F];
        tmp2 = vals[5] - (tmp1 << 6);
        retbuf = retbuf + charset[tmp2 & 0x3F];
        return retbuf;
    }

    private String getOTP32(String hash) {
        char[] charset = "0123456789abcdefghkmnoprstuvwxyz".toCharArray();
        String retbuf = "";
        int tmp2 = 0;
        char[] vals = this.hexToChar(hash);
        int tmp1 = vals[0] >> 3;
        retbuf = retbuf + charset[tmp1 & 0x1F];
        tmp2 = vals[0] - (tmp1 << 3);
        tmp1 = vals[1] >> 6;
        retbuf = retbuf + charset[tmp1 + tmp2 & 0x1F];
        tmp2 = vals[1] - (tmp1 << 6) >> 1;
        retbuf = retbuf + charset[tmp2 & 0x1F];
        tmp2 = vals[1] - (vals[1] >> 1 << 1);
        tmp1 = vals[2] >> 4;
        retbuf = retbuf + charset[tmp1 + tmp2 & 0x1F];
        tmp2 = vals[2] - (tmp1 << 4);
        tmp1 = vals[3] >> 7;
        retbuf = retbuf + charset[tmp1 + tmp2 & 0x1F];
        tmp2 = vals[3] - (tmp1 << 7) >> 2;
        retbuf = retbuf + charset[tmp2 & 0x1F];
        tmp2 = vals[3] - (vals[3] - (tmp1 << 7) >> 2) << 2;
        tmp1 = vals[4] >> 5;
        retbuf = retbuf + charset[tmp1 + tmp2 & 0x1F];
        tmp2 = vals[4] - (tmp1 << 5);
        retbuf = retbuf + charset[tmp2 & 0x1F];
        tmp1 = vals[5] >> 3;
        retbuf = retbuf + charset[tmp1 & 0x1F];
        tmp2 = vals[5] - (tmp1 << 3);
        tmp1 = vals[6] >> 6;
        retbuf = retbuf + charset[tmp1 + tmp2 & 0x1F];
        return retbuf;
    }

    private void LoadTestDef() {
        char[] charset = "123456789abcdefhkmnprstuvwxyzABCDEFGHKMNPQRSTUVWXYZ=+[]&@#*!-?%:".toCharArray();
        try {
            this.PIN = "";
            this.rs.closeRecordStore();
            RecordStore.deleteRecordStore((String)"FreeAuth.DB");
            this.rs = RecordStore.openRecordStore((String)"FreeAuth.DB", (boolean)true);
            this.rs.addRecord("12".getBytes(), 0, "12".length());
            this.rs.setRecord(1, ("" + this.timez).getBytes(), 0, ("" + this.timez).length());
            for (int i = 0; i <= 3; ++i) {
                int x = 0;
                SecureRandom rand = new SecureRandom();
                this.PIN = "";
                do {
                    int j;
                    if ((j = rand.nextInt() * 63 * x) < 0) {
                        j *= -1;
                    }
                    j %= 63;
                    while (j > 64) {
                        j -= 64;
                    }
                    this.PIN = this.PIN + charset[j];
                    ++x;
                } while (this.PIN.length() < 16);
                this.tmpbuf = this.encodeString(this.PIN);
                this.rs.addRecord(this.tmpbuf.getBytes(), 0, this.tmpbuf.length());
                this.tmpbuf = "200701010101";
                this.rs.addRecord(this.tmpbuf.getBytes(), 0, this.tmpbuf.length());
                if (i == 0) {
                    this.tmpbuf = "FreeAuth.org";
                }
                if (i == 1) {
                    this.tmpbuf = "CAcert.org";
                }
                if (i == 2) {
                    this.tmpbuf = "e164.org";
                }
                if (i == 3) {
                    this.tmpbuf = "NodeDB.com";
                }
                this.rs.addRecord(this.tmpbuf.getBytes(), 0, this.tmpbuf.length());
            }
            this.PIN = "";
            this.currentRecord = -1;
            this.totalRecords = (this.rs.getNumRecords() - 1) / 3;
            this.tmpbuf = new String(this.rs.getRecord(1));
            System.out.println("timez: " + this.tmpbuf);
        }
        catch (RecordStoreException rse) {
            System.out.println("RS Error! Open");
        }
        this.mainApp();
    }

    private void doDBWipe() {
        this.totalRecords = 0;
        this.currentRecord = -1;
        this.initdate = "";
        this.secret = "";
        this.alias = "";
        this.seed = "";
        this.PIN = "";
        try {
            this.meta.closeRecordStore();
            RecordStore.deleteRecordStore((String)"FreeAuth.Meta");
        }
        catch (RecordStoreException rse) {
            System.out.println("RS Error! Destroy RS");
        }
        try {
            this.rs.closeRecordStore();
            RecordStore.deleteRecordStore((String)"FreeAuth.DB");
        }
        catch (RecordStoreException rse) {
            System.out.println("RS Error! Destroy RS");
        }
        this.destroyApp(false);
    }

    private String encodeString(String Encode) {
        String tmpStr = "";
        try {
            tmpStr = new String(this.secretdecode.encrypt(Encode));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tmpStr;
    }

    private String decodeString(byte[] Encoded) {
        String tmpStr = "";
        try {
            tmpStr = new String(this.secretdecode.decrypt(new String(Encoded)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tmpStr.length() <= 0) {
            tmpStr = new String(Encoded);
            tmpStr = new MD5(tmpStr).asHex();
        }
        if (tmpStr.indexOf(0) > 0) {
            tmpStr = tmpStr.substring(0, tmpStr.indexOf(0));
        }
        return tmpStr;
    }

    private String checkKey(char key, String tmpStr) {
        if (key < '0' | key > '9') {
            tmpStr = tmpStr + key;
            return tmpStr;
        }
        this.now = new Date();
        this.thispress = this.now.getTime();
        if (this.lastkey == key && this.lastpress + 2000L >= this.thispress && tmpStr.length() > 0) {
            int tmp = tmpStr.charAt(tmpStr.length() - 1);
            if (key == '1') {
                if (tmp == 49) {
                    tmp = 45;
                } else if (tmp == 45) {
                    tmp = 46;
                } else if (tmp == 46) {
                    tmp = 64;
                } else if (tmp == 64) {
                    tmp = 47;
                } else if (tmp == 47) {
                    tmp = 58;
                } else if (tmp == 58) {
                    tmp = 95;
                } else if (tmp == 95) {
                    tmp = 61;
                } else if (tmp == 61) {
                    tmp = 38;
                } else if (tmp == 38) {
                    tmp = 91;
                } else if (tmp == 91) {
                    tmp = 93;
                } else if (tmp == 93) {
                    tmp = 33;
                } else if (tmp == 33) {
                    tmp = 45;
                } else if (tmp == 45) {
                    tmp = 63;
                } else if (tmp == 63) {
                    tmp = 37;
                } else if (tmp == 37) {
                    tmp = 42;
                } else if (tmp == 42) {
                    tmp = 35;
                } else if (tmp == 35) {
                    tmp = 49;
                }
            } else if (key == '2') {
                if (tmp == 50) {
                    tmp = 97;
                } else if (tmp == 97) {
                    tmp = 98;
                } else if (tmp == 98) {
                    tmp = 99;
                } else if (tmp == 99) {
                    tmp = 65;
                } else if (tmp == 65) {
                    tmp = 66;
                } else if (tmp == 66) {
                    tmp = 67;
                } else if (tmp == 67) {
                    tmp = 50;
                }
            } else if (key == '3') {
                if (tmp == 51) {
                    tmp = 100;
                } else if (tmp == 100) {
                    tmp = 101;
                } else if (tmp == 101) {
                    tmp = 102;
                } else if (tmp == 102) {
                    tmp = 68;
                } else if (tmp == 68) {
                    tmp = 69;
                } else if (tmp == 69) {
                    tmp = 70;
                } else if (tmp == 70) {
                    tmp = 51;
                }
            } else if (key == '4') {
                if (tmp == 52) {
                    tmp = 103;
                } else if (tmp == 103) {
                    tmp = 104;
                } else if (tmp == 104) {
                    tmp = 105;
                } else if (tmp == 105) {
                    tmp = 71;
                } else if (tmp == 71) {
                    tmp = 72;
                } else if (tmp == 72) {
                    tmp = 73;
                } else if (tmp == 73) {
                    tmp = 52;
                }
            } else if (key == '5') {
                if (tmp == 53) {
                    tmp = 106;
                } else if (tmp == 106) {
                    tmp = 107;
                } else if (tmp == 107) {
                    tmp = 108;
                } else if (tmp == 108) {
                    tmp = 74;
                } else if (tmp == 74) {
                    tmp = 75;
                } else if (tmp == 75) {
                    tmp = 76;
                } else if (tmp == 76) {
                    tmp = 53;
                }
            } else if (key == '6') {
                if (tmp == 54) {
                    tmp = 109;
                } else if (tmp == 109) {
                    tmp = 110;
                } else if (tmp == 110) {
                    tmp = 111;
                } else if (tmp == 111) {
                    tmp = 77;
                } else if (tmp == 77) {
                    tmp = 78;
                } else if (tmp == 78) {
                    tmp = 79;
                } else if (tmp == 79) {
                    tmp = 54;
                }
            } else if (key == '7') {
                if (tmp == 55) {
                    tmp = 112;
                } else if (tmp == 112) {
                    tmp = 113;
                } else if (tmp == 113) {
                    tmp = 114;
                } else if (tmp == 114) {
                    tmp = 115;
                } else if (tmp == 115) {
                    tmp = 80;
                } else if (tmp == 80) {
                    tmp = 81;
                } else if (tmp == 81) {
                    tmp = 82;
                } else if (tmp == 82) {
                    tmp = 83;
                } else if (tmp == 83) {
                    tmp = 55;
                }
            } else if (key == '8') {
                if (tmp == 56) {
                    tmp = 116;
                } else if (tmp == 116) {
                    tmp = 117;
                } else if (tmp == 117) {
                    tmp = 118;
                } else if (tmp == 118) {
                    tmp = 84;
                } else if (tmp == 84) {
                    tmp = 85;
                } else if (tmp == 85) {
                    tmp = 86;
                } else if (tmp == 86) {
                    tmp = 56;
                }
            } else if (key == '9') {
                if (tmp == 57) {
                    tmp = 119;
                } else if (tmp == 119) {
                    tmp = 120;
                } else if (tmp == 120) {
                    tmp = 121;
                } else if (tmp == 121) {
                    tmp = 122;
                } else if (tmp == 122) {
                    tmp = 87;
                } else if (tmp == 87) {
                    tmp = 88;
                } else if (tmp == 88) {
                    tmp = 89;
                } else if (tmp == 89) {
                    tmp = 90;
                } else if (tmp == 90) {
                    tmp = 57;
                }
            } else if (key == '0') {
                if (tmp == 48) {
                    tmp = 32;
                } else if (tmp == 32) {
                    tmp = 43;
                } else if (tmp == 43) {
                    tmp = 48;
                }
            }
            tmpStr = tmpStr.substring(0, tmpStr.length() - 1) + (char)tmp;
        } else {
            tmpStr = tmpStr + key;
        }
        this.lastpress = this.now.getTime();
        this.lastkey = key;
        return tmpStr;
    }
}

